/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.secureconfig;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.googlesource.gerrit.plugins.secureconfig.Codec;
import com.googlesource.gerrit.plugins.secureconfig.SecureConfigSettings;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PBECodec
implements Codec {
    private static final Logger log = LoggerFactory.getLogger(PBECodec.class);
    byte[] salt = new byte[]{125, 96, 67, 95, 2, -23, -32, -82};
    private static final int iterationCount = 2048;
    private final SecureConfigSettings config;

    @Inject
    public PBECodec(SecureConfigSettings config) {
        Provider provider = Security.getProvider(config.getJCEProvider());
        Security.addProvider(provider);
        this.config = config;
    }

    @Override
    public String encode(String s) {
        try {
            Key sKey = this.generateKey();
            Cipher encoder = this.getCipher();
            encoder.init(1, sKey, this.getCipherParameterSpec());
            return new String(Base64.getEncoder().encodeToString(encoder.doFinal(s.getBytes(this.config.getEncoding()))));
        }
        catch (Exception e) {
            log.error("encode() failed", (Throwable)e);
            throw new IllegalArgumentException("encode() failed", e);
        }
    }

    @Override
    public String decode(String s) {
        try {
            Cipher encoder = this.getCipher();
            Key sKey = this.generateKey();
            encoder.init(2, sKey, this.getCipherParameterSpec());
            return new String(encoder.doFinal(Base64.getDecoder().decode(s)), this.config.getEncoding());
        }
        catch (Exception e) {
            log.error("decode() failed", (Throwable)e);
            throw new IllegalArgumentException("encode() failed", e);
        }
    }

    private PBEParameterSpec getCipherParameterSpec() {
        return new PBEParameterSpec(this.salt, 2048);
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher encoder = Cipher.getInstance(this.config.getCipher(), this.config.getJCEProvider());
        return encoder;
    }

    private Key generateKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        PBEKeySpec pbeSpec = new PBEKeySpec(this.config.getPassword());
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(this.config.getCipher(), this.config.getJCEProvider());
        return keyFact.generateSecret(pbeSpec);
    }
}

