/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.secureconfig;

import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

@Singleton
public class SecureConfigSettings {
    private static final String SECURE_CONFIG = "secureConfig";
    private static final String PASSWORD_DEVICE = "passwordDevice";
    private static final String PASSWORD_LENGTH = "passwordLength";
    private static final int DEF_PASSWORD_LENGTH = 8;
    private static final String CIPHER = "cipher";
    private static final String ENCODING = "encoding";
    private static final String DEF_ENCODING = "UTF-8";
    private static final String JCE_PROVIDER = "jceProvider";
    private static final String DEF_JCE_PROVIDER = "SunJCE";
    private final FileBasedConfig gerritConfig;
    private final char[] password;

    @Inject
    SecureConfigSettings(SitePaths site) throws IOException, ConfigInvalidException {
        Config baseConfig = new Config();
        baseConfig.setString(SECURE_CONFIG, null, CIPHER, "PBEWithMD5AndDES");
        baseConfig.setString(SECURE_CONFIG, null, PASSWORD_DEVICE, "/dev/zero");
        baseConfig.setInt(SECURE_CONFIG, null, PASSWORD_LENGTH, 8);
        baseConfig.setString(SECURE_CONFIG, null, ENCODING, DEF_ENCODING);
        baseConfig.setString(SECURE_CONFIG, null, JCE_PROVIDER, DEF_JCE_PROVIDER);
        this.gerritConfig = new FileBasedConfig(baseConfig, site.gerrit_config.toFile(), FS.DETECTED);
        this.gerritConfig.load();
        this.password = this.readPassword();
    }

    String getCipher() {
        return this.gerritConfig.getString(SECURE_CONFIG, null, CIPHER);
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getEncoding() {
        return this.gerritConfig.getString(SECURE_CONFIG, null, ENCODING);
    }

    public String getJCEProvider() {
        return this.gerritConfig.getString(SECURE_CONFIG, null, JCE_PROVIDER);
    }

    private char[] readPassword() throws IOException {
        Path passwordDevice = Paths.get(this.gerritConfig.getString(SECURE_CONFIG, null, PASSWORD_DEVICE), new String[0]);
        try (FileInputStream in = new FileInputStream(passwordDevice.toFile());){
            byte[] passphrase = new byte[this.gerritConfig.getInt(SECURE_CONFIG, PASSWORD_LENGTH, 8)];
            in.read(passphrase);
            char[] cArray = new String(Base64.getEncoder().encode(passphrase)).toCharArray();
            return cArray;
        }
    }
}

