/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.secureconfig;

import com.google.common.collect.FluentIterable;
import com.google.gerrit.common.FileUtil;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.googlesource.gerrit.plugins.secureconfig.Codec;
import com.googlesource.gerrit.plugins.secureconfig.PBECodec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

@Singleton
public class SecureConfigStore
extends SecureStore {
    private static final String SECURE_CONFIG_FILE = "secure.config";
    private final FileBasedConfig sec;
    private final Map<String, FileBasedConfig> pluginSec;
    private final SitePaths site;
    private final Codec codec;
    private long secFileLastmodified;
    private final Path secure_config;

    @Inject
    SecureConfigStore(SitePaths site, PBECodec codec) {
        this.site = site;
        this.secure_config = site.etc_dir.resolve(SECURE_CONFIG_FILE);
        this.codec = codec;
        this.sec = new FileBasedConfig(this.secure_config.toFile(), FS.DETECTED);
        try {
            this.sec.load();
            this.secFileLastmodified = this.sec.getFile().lastModified();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new RuntimeException("Cannot load secure.config", e);
        }
        this.pluginSec = new HashMap<String, FileBasedConfig>();
    }

    public String[] getList(String section, String subsection, String name) {
        return (String[])Arrays.stream(this.sec.getStringList(section, subsection, name)).map(this.codec::decode).toArray(String[]::new);
    }

    public synchronized String[] getListForPlugin(String pluginName, String section, String subsection, String name) {
        FileBasedConfig cfg = null;
        if (this.pluginSec.containsKey(pluginName)) {
            cfg = this.pluginSec.get(pluginName);
        } else {
            String filename = pluginName + ".secure.config";
            File pluginConfigFile = this.site.etc_dir.resolve(filename).toFile();
            if (pluginConfigFile.exists()) {
                cfg = new FileBasedConfig(pluginConfigFile, FS.DETECTED);
                try {
                    cfg.load();
                    this.pluginSec.put(pluginName, cfg);
                }
                catch (IOException | ConfigInvalidException e) {
                    throw new RuntimeException("Cannot load " + filename, e);
                }
            }
        }
        return cfg != null ? (String[])FluentIterable.from((Object[])cfg.getStringList(section, subsection, name)).transform(this.codec::decode).toArray(String.class) : null;
    }

    public void setList(String section, String subsection, String name, List<String> values) {
        if (values != null) {
            this.sec.setStringList(section, subsection, name, values.stream().map(this.codec::encode).collect(Collectors.toList()));
        } else {
            this.sec.unset(section, subsection, name);
        }
        this.save();
    }

    public void unset(String section, String subsection, String name) {
        this.sec.unset(section, subsection, name);
        this.save();
    }

    public Iterable<SecureStore.EntryKey> list() {
        ArrayList<SecureStore.EntryKey> result = new ArrayList<SecureStore.EntryKey>();
        for (String section : this.sec.getSections()) {
            for (String subsection : this.sec.getSubsections(section)) {
                for (String name : this.sec.getNames(section, subsection)) {
                    result.add(new SecureStore.EntryKey(section, subsection, name));
                }
            }
            for (String name : this.sec.getNames(section)) {
                result.add(new SecureStore.EntryKey(section, null, name));
            }
        }
        return result;
    }

    public boolean isOutdated() {
        long secFileCurrLastModified = this.sec.getFile().lastModified();
        return secFileCurrLastModified > this.secFileLastmodified;
    }

    public void reload() {
        try {
            this.sec.load();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new IllegalStateException(e);
        }
    }

    private void save() {
        try {
            this.saveSecure(this.sec);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot save secure.config", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecure(FileBasedConfig sec) throws IOException {
        if (FileUtil.modified((FileBasedConfig)sec)) {
            byte[] out = Constants.encode((String)sec.toText());
            File path = sec.getFile();
            LockFile lf = new LockFile(path);
            if (!lf.lock()) {
                throw new IOException("Cannot lock " + String.valueOf(path));
            }
            try {
                FileUtil.chmod((int)384, (File)new File(path.getParentFile(), path.getName() + ".lock"));
                lf.write(out);
                if (!lf.commit()) {
                    throw new IOException("Cannot commit write to " + String.valueOf(path));
                }
            }
            finally {
                lf.unlock();
            }
        }
    }
}

