/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.gerrit.plugins.automerge;

import com.criteo.gerrit.plugins.automerge.AutomergeConfig;
import com.criteo.gerrit.plugins.automerge.Change;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.Change;
import com.google.gerrit.entities.Project;
import com.google.gerrit.entities.SubmitRequirement;
import com.google.gerrit.entities.SubmitRequirementResult;
import com.google.gerrit.exceptions.StorageException;
import com.google.gerrit.extensions.api.changes.RelatedChangeAndCommitInfo;
import com.google.gerrit.extensions.api.changes.RelatedChangesInfo;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.client.ChangeStatus;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.Emails;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.ChangePermissionOrLabel;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.restapi.change.GetRelated;
import com.google.gerrit.server.restapi.change.Submit;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicityHelper {
    private static final Logger log = LoggerFactory.getLogger(AtomicityHelper.class);
    @Inject
    ChangeData.Factory changeDataFactory;
    @Inject
    AutomergeConfig config;
    @Inject
    private IdentifiedUser.GenericFactory factory;
    @Inject
    GetRelated getRelated;
    @Inject
    Submit submitter;
    @Inject
    Emails emails;
    @Inject
    ChangeNotes.Factory changeNotesFactory;
    @Inject
    PermissionBackend permissionBackend;
    @Inject
    ChangeResource.Factory changeResourceFactory;

    public boolean hasDependentReview(String project, int number) throws Exception {
        RevisionResource r = this.getRevisionResource(project, number);
        RelatedChangesInfo related = (RelatedChangesInfo)this.getRelated.apply(r).value();
        log.debug(String.format("Checking for related changes on review %d", number));
        String checkedCommitSha1 = r.getPatchSet().commitId().name();
        int firstParentIndex = 0;
        int i = 0;
        for (RelatedChangeAndCommitInfo c : related.changes) {
            if (checkedCommitSha1.equals(c.commit.commit)) {
                firstParentIndex = i + 1;
                log.debug(String.format("First parent index on review %d is %d on commit %s", number, firstParentIndex, c.commit.commit));
                break;
            }
            ++i;
        }
        boolean hasNonMergedParent = false;
        for (RelatedChangeAndCommitInfo c : related.changes.subList(firstParentIndex, related.changes.size())) {
            if (ChangeStatus.MERGED.toString().equals(c.status)) continue;
            log.info(String.format("Found non merged parent commit on review %d: %s", number, c.commit.commit));
            hasNonMergedParent = true;
            break;
        }
        return hasNonMergedParent;
    }

    public boolean isAtomicReview(Change change) {
        boolean atomic = change.topic != null && change.topic.startsWith(this.config.getTopicPrefix());
        log.debug(String.format("Checking if change %s is an atomic change: %b", change.number, atomic));
        return atomic;
    }

    public boolean isSubmittable(String project, int change) {
        ChangeData changeData = this.changeDataFactory.create(Project.nameKey((String)project), com.google.gerrit.entities.Change.id((int)change));
        for (Map.Entry req : changeData.submitRequirementsIncludingLegacy().entrySet()) {
            log.debug(String.format("Checking if change %d is satisfy %s submit requirement.", change, ((SubmitRequirement)req.getKey()).name()));
            if (((SubmitRequirementResult)req.getValue()).fulfilled()) continue;
            log.debug(String.format("Change %d is not submitable: requirement %s is not fulfilled", change, ((SubmitRequirement)req.getKey()).name()));
            return false;
        }
        log.debug(String.format("Change %d is submitable", change));
        return true;
    }

    public void mergeReview(String project, int number) throws Exception {
        this.submitter.apply(this.getRevisionResource(project, number), new SubmitInput());
    }

    public RevisionResource getRevisionResource(String project, int changeNumber) {
        Change.Id changeId = com.google.gerrit.entities.Change.id((int)changeNumber);
        ChangeNotes notes = this.changeNotesFactory.createChecked(Project.nameKey((String)project), changeId);
        try {
            this.permissionBackend.user((CurrentUser)this.getBotUser()).change(notes).check((ChangePermissionOrLabel)ChangePermission.READ);
            ChangeData changeData = this.changeDataFactory.create(Project.nameKey((String)project), changeId);
            RevisionResource r = new RevisionResource(this.changeResourceFactory.create(changeData.notes(), (CurrentUser)this.getBotUser()), changeData.currentPatchSet());
            return r;
        }
        catch (AuthException | PermissionBackendException e) {
            throw new NoSuchChangeException(changeId);
        }
    }

    private IdentifiedUser getBotUser() {
        try {
            ImmutableSet ids = this.emails.getAccountFor(this.config.getBotEmail());
            if (ids.isEmpty()) {
                throw new RuntimeException("No user found with email: " + this.config.getBotEmail());
            }
            return this.factory.create((Account.Id)ids.iterator().next());
        }
        catch (StorageException | IOException e) {
            throw new RuntimeException("Unable to get account with email: " + this.config.getBotEmail(), e);
        }
    }
}

