/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.gerrit.plugins.automerge;

import com.criteo.gerrit.plugins.automerge.AtomicityHelper;
import com.criteo.gerrit.plugins.automerge.AutomergeConfig;
import com.criteo.gerrit.plugins.automerge.Change;
import com.criteo.gerrit.plugins.automerge.PluginComment;
import com.criteo.gerrit.plugins.automerge.ReviewUpdater;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.data.AccountAttribute;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.events.ChangeEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.EventListener;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.gerrit.server.events.ReviewerDeletedEvent;
import com.google.gerrit.server.events.TopicChangedEvent;
import com.google.gerrit.server.git.MergeUtilFactory;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.restapi.change.GetRelated;
import com.google.gerrit.server.restapi.change.PostReview;
import com.google.gerrit.server.restapi.change.Submit;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticMerger
implements EventListener,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(AutomaticMerger.class);
    @Inject
    private GerritApi api;
    @Inject
    private AtomicityHelper atomicityHelper;
    @Inject
    ChangeData.Factory changeDataFactory;
    @Inject
    private AutomergeConfig config;
    @Inject
    GetRelated getRelated;
    @Inject
    MergeUtilFactory mergeUtilFactory;
    @Inject
    Provider<PostReview> reviewer;
    @Inject
    private ReviewUpdater reviewUpdater;
    @Inject
    Submit submitter;

    public synchronized void onEvent(Event event) {
        if (event instanceof TopicChangedEvent || event instanceof ReviewerDeletedEvent || event instanceof PatchSetCreatedEvent) {
            Change change = Change.from((ChangeAttribute)((ChangeEvent)event).change.get());
            this.onNewOrChangedPatchSet(change);
        } else if (event instanceof CommentAddedEvent) {
            this.onCommentAdded((CommentAddedEvent)event);
        }
        if (event instanceof RefUpdatedEvent) {
            this.onRefUpdatedEvent((RefUpdatedEvent)event);
        }
    }

    private void onNewOrChangedPatchSet(Change change) {
        if (this.atomicityHelper.isAtomicReview(change)) {
            this.processNewAtomicPatchSet(change);
        }
        try {
            this.autoSubmitIfMergeable(change);
        }
        catch (Exception e) {
            log.error("An exception occured while trying to merge change #" + change.number, (Throwable)e);
        }
    }

    private void onCommentAdded(CommentAddedEvent newComment) {
        if (!this.shouldProcessCommentEvent(newComment)) {
            return;
        }
        ChangeAttribute change = (ChangeAttribute)newComment.change.get();
        try {
            this.checkReviewExists(change.number);
            this.autoSubmitIfMergeable(Change.from(change));
        }
        catch (Exception e) {
            log.error("An exception occured while trying to atomic merge a change.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void onRefUpdatedEvent(RefUpdatedEvent event) {
        String refName = event.getRefName();
        String projectName = event.getProjectNameKey().get();
        try {
            this.api.changes().query("branch:" + refName + " project:" + projectName + " is:submittable").get().forEach(submittable -> {
                try {
                    log.info("Found another submittable change #" + submittable._number + " on project " + projectName + " during update of ref " + refName + ": Submitting ...");
                    this.autoSubmitIfMergeable(Change.from(submittable));
                }
                catch (Exception e) {
                    log.error("Cannot autosubmit change " + submittable._number + " on project " + projectName + " to ref " + refName, (Throwable)e);
                }
            });
        }
        catch (RestApiException e) {
            log.error("Cannot query submittable changes on project " + projectName + " for ref " + refName);
        }
    }

    private void autoSubmitIfMergeable(Change change) throws Exception {
        if (this.atomicityHelper.isSubmittable(change.project, change.number)) {
            if (this.atomicityHelper.isAtomicReview(change)) {
                this.attemptToMergeAtomic(change);
            } else {
                this.attemptToMergeNonAtomic(change);
            }
        }
    }

    private boolean shouldProcessCommentEvent(CommentAddedEvent comment) {
        AccountAttribute account = (AccountAttribute)comment.author.get();
        if (!this.config.getBotEmail().equals(account.email)) {
            return true;
        }
        return !comment.comment.contains("[Autosubmitter] ");
    }

    private void attemptToMergeAtomic(Change change) throws Exception {
        ArrayList related = Lists.newArrayList();
        if (this.atomicityHelper.isAtomicReview(change)) {
            related.addAll(this.api.changes().query("status: open AND topic: " + change.topic).withOption(ListChangesOption.CURRENT_REVISION).get());
        } else {
            ChangeApi changeApi = this.api.changes().id(change.project, change.branch, change.id);
            related.add(changeApi.get(EnumSet.of(ListChangesOption.CURRENT_REVISION)));
        }
        for (ChangeInfo info : related) {
            if (this.atomicityHelper.isSubmittable(info.project, info._number)) continue;
            log.info("Change {} is not submittable because same topic change {} has not all approvals.", (Object)change.number, (Object)info._number);
            return;
        }
        for (ChangeInfo info : related) {
            boolean dependsOnNonMergedCommit = this.atomicityHelper.hasDependentReview(info.project, info._number);
            if (info.mergeable.booleanValue() && !dependsOnNonMergedCommit) continue;
            log.info("Change {} is not mergeable because same topic change {} {}", new Object[]{change.number, info._number, info.mergeable == false ? "is non mergeable" : "depends on a non merged commit."});
            PluginComment comment = info.mergeable == false ? this.config.cantMergeGitConflict : this.config.cantMergeDependsOnNonMerged;
            this.reviewUpdater.commentOnReview(change.project, change.number, String.format(comment.getContent(), info._number));
            return;
        }
        log.info("Submitting atomic change {}...", (Object)change.number);
        for (ChangeInfo info : related) {
            this.atomicityHelper.mergeReview(info.project, info._number);
        }
    }

    private void attemptToMergeNonAtomic(Change change) throws Exception {
        boolean dependsOnNonMergedCommit = this.atomicityHelper.hasDependentReview(change.project, change.number);
        if (dependsOnNonMergedCommit) {
            log.info("Change {} is not mergeable because it depends on a non merged commit.", (Object)change.number);
            return;
        }
        log.info("Submitting non-atomic change {}...", (Object)change.number);
        this.atomicityHelper.mergeReview(change.project, change.number);
    }

    private void processNewAtomicPatchSet(Change change) {
        try {
            this.checkReviewExists(change.number);
            log.info(String.format("Detected atomic review on change %d.", change.number));
            this.reviewUpdater.commentOnReview(change.project, change.number, this.config.atomicReviewDetected.getContent());
            if (this.atomicityHelper.hasDependentReview(change.project, change.number)) {
                log.info(String.format("Warn the user on change %d, as other atomic changes exists on the same repository.", change.number));
                this.reviewUpdater.commentOnReview(change.project, change.number, this.config.atomicReviewsSameRepo.getContent());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkReviewExists(int reviewNumber) throws RestApiException {
        this.api.changes().id(reviewNumber).get(EnumSet.of(ListChangesOption.CURRENT_REVISION));
    }

    public void start() {
        log.info("Starting automatic merger plugin.");
    }

    public void stop() {
    }
}

