/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.gerrit.plugins.automerge;

import com.criteo.gerrit.plugins.automerge.AtomicityHelper;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.restapi.change.PostReview;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class ReviewUpdater {
    public static final String commentsPrefix = "[Autosubmitter] ";
    @Inject
    Provider<PostReview> reviewer;
    @Inject
    private AtomicityHelper atomicityHelper;

    public void commentOnReview(String project, int number, String comment) throws Exception {
        ReviewInput reviewInput = this.createComment(comment);
        this.applyComment(project, number, reviewInput);
    }

    private ReviewInput createComment(String comment) {
        return new ReviewInput().message(commentsPrefix + comment);
    }

    private void applyComment(String project, int number, ReviewInput comment) throws Exception {
        RevisionResource r = this.atomicityHelper.getRevisionResource(project, number);
        ((PostReview)this.reviewer.get()).apply(r, comment);
    }
}

